﻿using System;
using System.Windows.Forms;

namespace eCommSignatureDemo
{
    /// <summary>
    /// In the same folder with the executable the following libraries should be added:
    /// libeay32.dll
    /// ssleay32.dll
    /// If no MS Visual C++ Redistributable is installed on machine,
    /// put in the same folder with the executable msvcr100.dll,
    /// which can be found in Libs folder (for x86 or x64 system) of eCommSignature project
    /// </summary>
    public partial class DemoForm : Form
    {
        private string _privateKeyFileName;
        public DemoForm()
        {
            InitializeComponent();
        }

        private void BtnBrowseClick(object sender, EventArgs e)
        {
            //Browse private key file
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.Filter = "PEM Files (*.pem)|*.pem";
            DialogResult result = openFileDialog.ShowDialog();
            if (result == DialogResult.OK)
            {
                _privateKeyFileName = openFileDialog.FileName;
                this.tbxKeyFile.Text = openFileDialog.FileName;
            }
        }

        private void BtnCreateClick(object sender, EventArgs e)
        {
            string macData = this.tbxMac.Text;
            string prefix = this.tbxPrefix.Text;

            //Create signature
            try
            {
                string signature = eCommSignature.Signature.CreateSignature(macData, prefix, _privateKeyFileName);
                this.richTextBoxResult.Text = signature;
                MessageBox.Show("Signature successfully generated!", "Success", MessageBoxButtons.OK,
                                MessageBoxIcon.Information);
            }
            catch (ArgumentException aex)
            {
                MessageBox.Show(
                    string.Format("Could not create signature{0}Error message: {1}", Environment.NewLine, aex.Message),
                    "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
            catch (Exception ex)
            {
                MessageBox.Show(
                    string.Format("Could not create signature{0}Error message: {1}", Environment.NewLine, ex.Message),
                    "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}
