﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace eCommSignatureDemo
{
    public partial class VerificationForm : Form
    {
        public VerificationForm()
        {
            InitializeComponent();
        }

        private void BtnVerifyClick(object sender, EventArgs e)
        {
            string exponent = this.tbxExponent.Text;
            string modulus = this.rtbModulus.Text;
            //Note: pSign length should be equal to public key's size (modulus length)
            string pSign = this.rtbPsign.Text;

            try
            {
                string decryptedPsign = eCommSignature.Signature.VerifySignature(pSign, modulus, exponent);
                this.rtbResult.Text = decryptedPsign;
            }
            catch (ArgumentException aex)
            {
                MessageBox.Show(aex.Message, "Warning", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
            catch(Exception ex)
            {
                MessageBox.Show(
                    string.Format("Could not verify signature{0}Error message: {1}", Environment.NewLine, ex.Message),
                    "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}
